% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{countRead}
\alias{countRead}
\alias{countRead,GbsrGenotypeData-method}
\title{Count reads per sample and per marker.}
\usage{
countRead(object, target = "both", node = "raw", ...)

\S4method{countRead}{GbsrGenotypeData}(object, target, node)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{target}{Either of "marker" and "sample".}

\item{node}{Either of "raw" and "filt". See details.}

\item{...}{Unused.}
}
\value{
A \link{GbsrGenotypeData} object with read count information.
}
\description{
This function calculates several summary statistics of read counts
per marker and per sample. Those values will be stored
in the SnpAnnotaionDataFrame slot and the \link{sample} slot
and obtained via getter functions, e.g.
\code{\link[=getCountReadRef]{getCountReadRef()}} and \code{\link[=getCountReadAlt]{getCountReadAlt()}}.
This function first calculates normalized allele read counts by dividing
allele read counts at each marker in each sample by the total allele read
of the sample followed by multiplication by 10^6. In other words, it
calculates reads per million (rpm). Then, the function calculates
mean, standard deviation, quantile values of rpm per marker and per sample.
The results will be stored in the SnpAnnotaionDataFrame slot and the
\link{sample} slot and obtained via getter functions, e.g.
\code{\link[=getMeanReadRef]{getMeanReadRef()}} and \code{\link[=getMedianReadAlt]{getMedianReadAlt()}}.
}
\details{
Read count data can be obtained from the "annotation/format/AD/data" node
or the "annotation/format/AD/filt.data" node of the GDS file
with \code{node = "raw"} or \code{node = "filt"}, respectively.
The \code{\link[=setCallFilter]{setCallFilter()}} function generate filtered read count data
in the "annotation/format/AD/filt.data" node which can be accessed as
mentioned above.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Summarize the read count information and store them in the
# [marker] and [sample] slots of the [GbsrGenotypeData] object.
gds <- countRead(gds)

# Get the total read counts per marker
read_depth_per_marker <- getCountRead(gds, target = "marker")

# Get the proportion of reference allele rads per marker.
reference_read_freq <- getCountReadRef(gds, target = "marker", prop = TRUE)

# Draw histgrams of reference allele read counts per sample and marker.
histGBSR(gds, stats = "ad_ref")

# Close the connection to the GDS file.
closeGDS(gds)

}
