% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GARS_createRndPopulation.R
\name{GARS_create_rnd_population}
\alias{GARS_create_rnd_population}
\title{Create a random chromosomes population}
\usage{
GARS_create_rnd_population(data, chr.len, chr.num = 1000)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object or a matrix or
a data.frame. In case of matrix or data.frame:
\itemize{
 \item Rows and Cols have to be, respectively, observations
 and features. The variables are tipically genes;
 \item GARS also accept other -omic features as well as any
 continuous or factorial variables
 (e.g. sex, age, cholesterol level,...);
 \item Usually the number of observation is << than the number
 of features
}'}

\item{chr.len}{The length of chromosomes. This value corresponds
to the desired length of the feature set.}

\item{chr.num}{The number of chromosomes to generate. Default is
1000}
}
\value{
A matrix representing the chromosomes population: each column
is a chromosome and each element correspond to the feature position in
'data'
}
\description{
This function creates the initial random population
of chromosomes
}
\examples{
# use example data:
data(GARS_data_norm)
GARS_create_rnd_population(GARS_data_norm, chr.len=10, chr.num=100)

}
\author{
Mattia Chiesa, Luca Piacentini
}
