% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_plotFunctions.R
\name{PlotManualBars}
\alias{PlotManualBars}
\title{PlotManualBars}
\usage{
PlotManualBars(
  fsom,
  fcs = NULL,
  manualVector,
  manualOrder = NULL,
  colors = NULL,
  list_insteadof_plots = FALSE
)
}
\arguments{
\item{fsom}{FlowSOM object, as generated by \code{\link{FlowSOM}} or 
by \code{\link{NewData}}. The clusters and metaclusters 
will be plotted in the order of the factor levels.}

\item{fcs}{FCS file that should be mapped on the FlowSOM object.
Default is NULL.}

\item{manualVector}{Vector with cell labels, e.g. obtained by manual gating}

\item{manualOrder}{Optional vector with unique cell labels to fix in which
order the cell labels should be shown}

\item{colors}{Optional color vector, should have the same length as
the number of unique cell labels}

\item{list_insteadof_plots}{If \code{FALSE} (default), it returns multiple 
plots. If \code{TRUE}, it returns a list of 
ggplot objects}
}
\value{
Either a plot or a ggplot objects list is returned.
}
\description{
Function to plot the manual labels per FlowSOM (meta)cluster in a barplot
}
\examples{
# Identify the files
fcs_file <- system.file("extdata", "68983.fcs", package = "FlowSOM")
gating_file <- system.file("extdata", "gatingResult.csv", package = "FlowSOM")

# Specify the cell types of interest for assigning one label per cell
cellTypes <- c("B cells",
                "gd T cells", "CD4 T cells", "CD8 T cells",
                "NK cells", "NK T cells")
                
# Load manual labels (e.g. GetFlowJoLabels can be used to extract labels from
# an fcs file)
 
gatingResult <- as.factor(read.csv(gating_file, header = FALSE)[, 1])

# Build a FlowSOM object
flowSOM.res <- FlowSOM(fcs_file,
                       scale = TRUE,
                       compensate = TRUE, 
                       transform = TRUE,
                       toTransform = 8:18, 
                       colsToUse = c(9, 12, 14:18),
                       nClus = 10,
                       seed = 1)

# Make the barplot of the manual labels
pdf("PlotManualBars.pdf")
PlotManualBars(fsom = flowSOM.res,
               fcs = fcs_file,
               manualVector = gatingResult,
               manualOrder = c(cellTypes, "Unlabeled"),
               colors = c("#F8766D", "#B79F00", "#00BA38", "#00BFC4", 
                          "#619CFF", "#F564E3", "#D3D3D3"))
dev.off()

}
