% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_metaClustering.R
\name{GetMetaclusterPercentagesPositive}
\alias{GetMetaclusterPercentagesPositive}
\title{Get percentage-positive values for all metaclusters}
\usage{
GetMetaclusterPercentagesPositive(
  fsom,
  cutoffs,
  colsUsed = FALSE,
  prettyColnames = FALSE
)
}
\arguments{
\item{fsom}{FlowSOM object as generated by the FlowSOM function
or the BuildSOM function}

\item{cutoffs}{named numeric vector. Upper bounds of negative
population fluorescence-intensity values for each
marker / channel.}

\item{colsUsed}{logical. Should report only the columns used to 
build the SOM. Default = FALSE.}

\item{prettyColnames}{logical. Should report pretty column names instead
of standard column names. Default = FALSE.}
}
\value{
Matrix with percentages of cells that are positive in selected markers per each metacluster
}
\description{
Get percentage-positive values for all metaclusters
}
\examples{
fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
flowSOM.res <- FlowSOM(fileName, compensate = TRUE, transform = TRUE,
                      scale = TRUE, colsToUse = c(9, 12, 14:18), nClus = 10)
perc_pos <- GetMetaclusterPercentagesPositive(flowSOM.res, cutoffs = c('CD4' = 5000))
}
