% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_buildSOM.R
\name{GetFeatures}
\alias{GetFeatures}
\title{GetFeatures}
\usage{
GetFeatures(
  fsom,
  files,
  level = c("clusters", "metaclusters"),
  type = "counts",
  MFI = NULL,
  positive_cutoffs = NULL,
  filenames = NULL,
  silent = FALSE
)
}
\arguments{
\item{fsom}{FlowSOM object as generated by the FlowSOM function
or the BuildSOM function}

\item{files}{Either a vector of FCS files or paths to FCS files}

\item{level}{Level(s) of interest. Default is c("clusters",
"metaclusters"), but can also be only one of them. 
Can be abbreviated.}

\item{type}{Type of features to extract. Default is "counts", 
can be a vector of "counts", "percentages", "MFIs"
and/or "percentages_positive" or abbreviations.}

\item{MFI}{Vector with channels / markers for which the MFI 
values must be returned when "MFIs" is in \code{type}}

\item{positive_cutoffs}{Named vector with fluorescence-intensity values
per channel / marker that are the upper bounds for
a negative population when "percentages_positive" is
in \code{type}}

\item{filenames}{An optional vector with filenames that will be used
as rownames in the count matrices. If NULL (default)
either the paths will be used or a numerical vector.}

\item{silent}{Logical. If \code{TRUE}, print progress messages.
Default = \code{FALSE}.}
}
\value{
matrix with features per population - type combination
}
\description{
Map FCS files on an existing FlowSOM object
}
\examples{
 # Build FlowSom result
 fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
 ff <- flowCore::read.FCS(fileName)
 ff <- flowCore::compensate(ff, flowCore::keyword(ff)[["SPILL"]])
 ff <- flowCore::transform(ff,
         flowCore::transformList(colnames(flowCore::keyword(ff)[["SPILL"]]),
                                flowCore::logicleTransform()))
 flowSOM.res <- FlowSOM(ff[1:1000, ], 
                        scale = TRUE, 
                        colsToUse = c(9, 12, 14:18),
                        nClus = 10)
   
 # Map new data
 counts <- GetFeatures(fsom = flowSOM.res, 
                       level = "clusters",
                       files = c(ff[1001:2000, ], ff[2001:3000, ]))
 features <- GetFeatures(fsom = flowSOM.res, 
                         files = c(ff[1001:2000, ], ff[2001:3000, ]),
                         type = c("counts", "percentages", "MFIs"), 
                         MFI = "APC-A", 
                         filenames = c("ff_1001-2000", "ff_2001-3000"))

 # Get percentages of positive cells
 positive_cutoffs <- c('CD8' = 1.5,
                       'CD4' = 0.3,
                       'CD19' = 1.3,
                       'CD3' = -0.3)
 
 perc_pos <- GetFeatures(fsom = flowSOM.res, 
                         files = c(ff[1001:2000, ], ff[2001:3000, ]),
                         type = c("percentages_positive"), 
                         positive_cutoffs = positive_cutoffs,
                         filenames = c("ff_1001-2000", "ff_2001-3000"))
                         
}
