% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_buildMST.R
\name{FlowSOMSubset}
\alias{FlowSOMSubset}
\title{FlowSOMSubset}
\usage{
FlowSOMSubset(fsom, ids)
}
\arguments{
\item{fsom}{FlowSOM object, as generated by \code{\link{BuildMST}}}

\item{ids}{Array containing the ids to keep}
}
\value{
FlowSOM object containing updated data and median values, 
   but with the same grid
}
\description{
FlowSOM subset
}
\details{
Take a subset from a FlowSOM object
}
\examples{
   # Read two files (Artificially, as we just split 1 file in 2 subsets)
   fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
   ff1 <- flowCore::read.FCS(fileName)[1:1000, ]
   flowCore::keyword(ff1)[["FIL"]] <- "File1"
   ff2 <- flowCore::read.FCS(fileName)[1001:2000, ]
   flowCore::keyword(ff2)[["FIL"]] <- "File2"
   
   flowSOM.res <- FlowSOM(flowCore::flowSet(c(ff1, ff2)), compensate = TRUE,
                          transform = TRUE, scale = TRUE,
                          colsToUse = c(9, 12, 14:18), maxMeta = 10)
   
   # see $metadata for subsets:
   flowSOM.res$metaData
   
   # Use only the second file, without changing the map
   fSOM2 <- FlowSOMSubset(flowSOM.res,
                          (flowSOM.res$metaData[[2]][1]):
                           (flowSOM.res$metaData[[2]][2]))

}
\seealso{
\code{\link{BuildMST}}
}
