% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_buildMST.R
\name{BuildMST}
\alias{BuildMST}
\title{BuildMST}
\usage{
BuildMST(fsom, silent = FALSE, tSNE = FALSE)
}
\arguments{
\item{fsom}{FlowSOM object, as generated by \code{\link{BuildSOM}}}

\item{silent}{If \code{TRUE}, no progress updates will be printed}

\item{tSNE}{If \code{TRUE}, an alternative t-SNE layout is computed as well}
}
\value{
FlowSOM object containing MST description
}
\description{
Build Minimal Spanning Tree
}
\details{
Add minimal spanning tree description to the FlowSOM object
}
\examples{
# Read from file, build self-organizing map
fileName <- system.file("extdata", "68983.fcs", package="FlowSOM")
flowSOM.res <- ReadInput(fileName, compensate=TRUE, transform = TRUE,
                         scale = TRUE)
flowSOM.res <- BuildSOM(flowSOM.res, colsToUse = c(9, 12, 14:18))

# Build the Minimal Spanning Tree
flowSOM.res <- BuildMST(flowSOM.res)

}
\seealso{
\code{\link{BuildSOM}}, \code{\link{PlotStars}}
}
