% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-.R
\name{getCom}
\alias{getCom}
\title{Get community}
\usage{
getCom(data, level, format = "name")
}
\arguments{
\item{data}{FELLA.DATA object}

\item{level}{Desired level, can be coded as a number or a character: 
1 or "pathway"; 2 or "module"; 3 or "enzyme"; 
4 or "reaction"; 5 or "compound".}

\item{format}{Format of the output, "name" returns KEGG IDs whereas 
"id" returns vertices IDs}
}
\value{
Vector of the names/ids of the desired KEGG graph community
}
\description{
Extractor function for all the nodes from a level/community of KEGG graph
}
\examples{
data(FELLA.sample)
## Pathways
getCom(FELLA.sample, 1, format = "name")
getCom(FELLA.sample, 1, format = "id")
## Modules
getCom(FELLA.sample, 2)
## Enzymes
head(getCom(FELLA.sample, 3))
## Reactions
head(getCom(FELLA.sample, 4))
## Compounds
head(getCom(FELLA.sample, 5))
}
