% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R,
%   R/SubsetRangedSummarizedExperiment.R, R/SubsetSingleCellExperiment.R,
%   R/SubsetSummarizedExperiment.R, R/SubsetSpatialExperiment.R,
%   R/SubsetTreeSummarizedExperiment.R
\name{subsetRownames}
\alias{subsetRownames}
\alias{subsetRownames<-}
\alias{subsetRownames,SubsetRangedSummarizedExperiment,character-method}
\alias{subsetRownames<-,SubsetRangedSummarizedExperiment,character-method}
\alias{subsetRownames,SubsetSingleCellExperiment,character-method}
\alias{subsetRownames<-,SubsetSingleCellExperiment,character-method}
\alias{subsetRownames,SubsetSummarizedExperiment,character-method}
\alias{subsetRownames<-,SubsetSummarizedExperiment,character-method}
\alias{subsetRownames,SubsetSpatialExperiment,character-method}
\alias{subsetRownames<-,SubsetSpatialExperiment,character-method}
\alias{subsetRownames,SubsetTreeSummarizedExperiment,character-method}
\alias{subsetRownames<-,SubsetTreeSummarizedExperiment,character-method}
\title{subsetRownames}
\usage{
subsetRownames(x, subsetName)

subsetRownames(x, subsetName) <- value

\S4method{subsetRownames}{SubsetRangedSummarizedExperiment,character}(x, subsetName)

\S4method{subsetRownames}{SubsetRangedSummarizedExperiment,character}(x, subsetName) <- value

\S4method{subsetRownames}{SubsetSingleCellExperiment,character}(x, subsetName)

\S4method{subsetRownames}{SubsetSingleCellExperiment,character}(x, subsetName) <- value

\S4method{subsetRownames}{SubsetSummarizedExperiment,character}(x, subsetName)

\S4method{subsetRownames}{SubsetSummarizedExperiment,character}(x, subsetName) <- value

\S4method{subsetRownames}{SubsetSpatialExperiment,character}(x, subsetName)

\S4method{subsetRownames}{SubsetSpatialExperiment,character}(x, subsetName) <- value

\S4method{subsetRownames}{SubsetTreeSummarizedExperiment,character}(x, subsetName)

\S4method{subsetRownames}{SubsetTreeSummarizedExperiment,character}(x, subsetName) <- value
}
\arguments{
\item{x}{Input \code{ExperimentSubset} object.}

\item{subsetName}{Name of the subset to set \code{colnames} to.}

\item{value}{Specify the rownames values to replace.}
}
\value{
A \code{vector} of \code{colnames}.

Input object with rownames set to a subset.
}
\description{
Get \code{rownames} from a subset in the \code{ExperimentSubset} object.

Set \code{colnames} to a subset in the \code{ExperimentSubset} object.
}
\examples{
data(sce_chcl, package = "scds")
es <- ExperimentSubset(sce_chcl)
es <- createSubset(es,
"subset1",
rows = c(10,11,50,56,98,99,102,105,109, 200),
cols = c(20,21,40,45,90,99,100,123,166,299),
parentAssay = "counts")
subsetRownames(es, "subset1")
}
