% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R,
%   R/SubsetRangedSummarizedExperiment.R, R/SubsetSingleCellExperiment.R,
%   R/SubsetSummarizedExperiment.R, R/SubsetSpatialExperiment.R,
%   R/SubsetTreeSummarizedExperiment.R
\name{subsetNames}
\alias{subsetNames}
\alias{subsetNames,SubsetRangedSummarizedExperiment-method}
\alias{subsetNames,SubsetSingleCellExperiment-method}
\alias{subsetNames,SubsetSummarizedExperiment-method}
\alias{subsetNames,SubsetSpatialExperiment-method}
\alias{subsetNames,SubsetTreeSummarizedExperiment-method}
\title{Get names of only the subsets in ExperimentSubset objects}
\usage{
subsetNames(x)

\S4method{subsetNames}{SubsetRangedSummarizedExperiment}(x)

\S4method{subsetNames}{SubsetSingleCellExperiment}(x)

\S4method{subsetNames}{SubsetSummarizedExperiment}(x)

\S4method{subsetNames}{SubsetSpatialExperiment}(x)

\S4method{subsetNames}{SubsetTreeSummarizedExperiment}(x)
}
\arguments{
\item{x}{\code{ExperimentSubset} Specify the input ES object.}
}
\value{
A \code{vector} of subset names.
}
\description{
Retrieves the names of the available subsets (not the subset 
  assays) in an \code{ExperimentSubset} object.
}
\examples{
data(sce_chcl, package = "scds")
es <- ExperimentSubset(sce_chcl)
es <- createSubset(es,
"subset1",
rows = c(10,11,50,56,98,99,102,105,109, 200),
cols = c(20,21,40,45,90,99,100,123,166,299),
parentAssay = "counts")
subsetNames(es)
}
