% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R,
%   R/SubsetRangedSummarizedExperiment.R, R/SubsetSingleCellExperiment.R,
%   R/SubsetSummarizedExperiment.R, R/SubsetSpatialExperiment.R,
%   R/SubsetTreeSummarizedExperiment.R
\name{subsetAssayCount}
\alias{subsetAssayCount}
\alias{subsetAssayCount,SubsetRangedSummarizedExperiment-method}
\alias{subsetAssayCount,SubsetSingleCellExperiment-method}
\alias{subsetAssayCount,SubsetSummarizedExperiment-method}
\alias{subsetAssayCount,SubsetSpatialExperiment-method}
\alias{subsetAssayCount,SubsetTreeSummarizedExperiment-method}
\title{Count method for subset assays in ExperimentSubset objects}
\usage{
subsetAssayCount(x)

\S4method{subsetAssayCount}{SubsetRangedSummarizedExperiment}(x)

\S4method{subsetAssayCount}{SubsetSingleCellExperiment}(x)

\S4method{subsetAssayCount}{SubsetSummarizedExperiment}(x)

\S4method{subsetAssayCount}{SubsetSpatialExperiment}(x)

\S4method{subsetAssayCount}{SubsetTreeSummarizedExperiment}(x)
}
\arguments{
\item{x}{\code{ExperimentSubset} Input \code{ExperimentSubset} object.}
}
\value{
A \code{numeric} value representing the sum of the subset count and
  subset assay count.
}
\description{
Get the count of the total available subsets and the subset
  assays inside these subsets in an \code{ExperimentSubset} object.
}
\examples{
data(sce_chcl, package = "scds")
es <- ExperimentSubset(sce_chcl)
es <- createSubset(es,
"subset1",
rows = c(10,11,50,56,98,99,102,105,109, 200),
cols = c(20,21,40,45,90,99,100,123,166,299),
parentAssay = "counts")
assay(es, "subset1",
subsetAssayName = "subset1pAssay") <- assay(es, "subset1")[,] + 1
subsetAssayCount(es)
}
