% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeEpiTxDbFromtRNAdb.R
\name{makeEpiTxDbFromtRNAdb}
\alias{makeEpiTxDbFromtRNAdb}
\alias{gettRNAdbDataAsGRanges}
\alias{listAvailableOrganismsFromtRNAdb}
\title{Create a \code{EpiTxDb} object from tRNAdb resources}
\usage{
gettRNAdbDataAsGRanges(
  organism,
  sequences = NULL,
  dbURL = tRNAdbImport::TRNA_DB_URL
)

makeEpiTxDbFromtRNAdb(
  organism,
  sequences = NULL,
  metadata = NULL,
  dbURL = tRNAdbImport::TRNA_DB_URL
)

listAvailableOrganismsFromtRNAdb()
}
\arguments{
\item{organism}{A \code{character} value for an organism available on the
tRNAdb website.}

\item{sequences}{A named \code{DNAStringSet} or \code{RNAStringSet}, which
will be used to associate a tRNAdb result with a specific transcript.}

\item{dbURL}{The URL to the tRNA db website.}

\item{metadata}{See \code{\link[=makeEpiTxDb]{makeEpiTxDb}}}
}
\value{
a \code{EpiTxDb} object.
}
\description{
\code{makeEpiTxDbFromtRNAdb} will make use of the tRNAdb online
resources and extract the modification information from the RNA database.

If a named \code{\link[Biostrings:XStringSet-class]{DNAStringSet}} is
provided as \code{sequences}, the result from the tRNAdb will be matched
against the sequences. Valid matches will be used as transcript identifiers
and returned after a check of modification compatibility with the provided
sequence. By this process multiple copies of transcripts can be associated
with a single modification.

\code{makeEpiTxDbFromtRNAdb} uses the functions provided by the
\code{\link[tRNAdbImport:tRNAdbImport]{tRNAdbImport}} package.
\code{\link[tRNAdbImport:import.tRNAdb]{import.tRNAdb}} will be used with
\code{database = "RNA"} and the three different values for \code{origin}.
}
\examples{
\dontrun{
# getting just the annotation data
etdb <- makeEpiTxDbFromtRNAdb("Saccharomyces cerevisiae")

# For associating the result with transcripts, provide and additional
# named DNAStringSet object. Matching will be done against each sequence
# allowing 5 mismatches and indels. The final result will be checked for
# validity regarding the identity of the modifications
etdb <- makeEpiTxDbFromtRNAdb("Saccharomyces cerevisiae",
                              some_transcript_sequences)
}
}
\references{
Juehling F, Moerl M, Hartmann RK, Sprinzl M, Stadler PF, Puetz J. 2009.
"tRNAdb 2009: compilation of tRNA sequences and tRNA genes." Nucleic Acids
Research, Volume 37 (suppl_1): D159–162. doi:10.1093/nar/gkn772.
}
