% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_chromosomes.R
\name{tidy_chromosomes}
\alias{tidy_chromosomes}
\title{Remove odd chromosomes from GRanges objects}
\usage{
tidy_chromosomes(
  gr,
  keep.X = TRUE,
  keep.Y = TRUE,
  keep.M = FALSE,
  keep.nonstandard = FALSE,
  genome = NULL
)
}
\arguments{
\item{gr}{Any GRanges object, or any another object with associated
\code{seqinfo} (or a \code{Seqinfo} object itself). The object should
typically have a standard genome associated with it, e.g. \code{genome(gr)
<- "hg38"}. \code{gr} can also be a list of such GRanges objects.}

\item{keep.X, keep.Y, keep.M, keep.nonstandard}{Logicals indicating which
non-autosomes should be kept. By default, sex chromosomes are kept, but
mitochondrial and non-standard chromosomes are removed.}

\item{genome}{An optional string that, if supplied, will be used to set the
genome of \code{gr}.}
}
\value{
A GRanges object in which both ranges and \code{seqinfo} associated
  with trimmed chromosomes have been removed.
}
\description{
This convenience function removes non-standard, mitochondrial, and/or sex
chromosomes from any GRanges object.
}
\details{
This function is adapted from \code{tidyChromosomes} in the
\code{BRGenomics} package licensed under the Artistic License 2.0.
Original author: Mike DeBerardine <https://github.com/mdeber>

Standard chromosomes are defined using the
  \code{\link[GenomeInfoDb]{standardChromosomes}} function
  from the \pkg{GenomeInfoDb} package.
}
\examples{
# make a GRanges
chrom <- c("chr2", "chr3", "chrX", "chrY", "chrM", "junk")
gr <- GenomicRanges::GRanges(seqnames = chrom,
              ranges = IRanges::IRanges(start = 2*(1:6), end = 3*(1:6)),
              strand = "+",
              seqinfo = Seqinfo::Seqinfo(chrom))
Seqinfo::genome(gr) <- "hg38"

gr

tidy_chromosomes(gr)

tidy_chromosomes(gr, keep.M = TRUE)

tidy_chromosomes(gr, keep.M = TRUE, keep.Y = FALSE)

tidy_chromosomes(gr, keep.nonstandard = TRUE)

}
\seealso{
\code{\link[GenomeInfoDb]{standardChromosomes}}
}
\author{
Mike DeBerardine
}
\keyword{internal}
