% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liftover_grlist.R
\name{liftover_grlist}
\alias{liftover_grlist}
\title{Liftover peak list}
\usage{
liftover_grlist(
  grlist,
  input_build,
  output_build = "hg19",
  style = "UCSC",
  keep_chr = paste0("chr", c(seq_len(22), "X", "Y")),
  as_grangeslist = FALSE,
  merge_all = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{grlist}{A named list of \link[GenomicRanges]{GRanges} objects,
or simply a single unlisted \link[GenomicRanges]{GRanges} object.
Can perform liftover within species or across species.}

\item{input_build}{The genome build of \code{grlist}.}

\item{output_build}{Desired genome build for
\code{grlist} to be lifted over to.}

\item{style}{Chromosome style,
set by \link[GenomeInfoDb]{seqlevelsStyle}.
\itemize{
\item{"UCSC" : }{Uses the chromosome style "chr1".}
\item{"NCBI" : }{Uses the chromosome style "1"}
}}

\item{keep_chr}{Which chromosomes to keep.}

\item{as_grangeslist}{Return as a \link[GenomicRanges]{GRangesList}.}

\item{merge_all}{Merge all \link[GenomicRanges]{GRanges} into a single
\link[GenomicRanges]{GRanges} object.}

\item{verbose}{Print messages.}
}
\value{
Named list of lifted \link[GenomicRanges]{GRanges} objects.
}
\description{
Perform genome build liftover to one or more
 \link[GenomicRanges]{GRanges} objects at once.
}
\examples{
grlist <- list("gr1"=GenomicRanges::GRanges("4:1-100000"),
               "gr2"=GenomicRanges::GRanges("6:1-100000"),
               "gr3"=GenomicRanges::GRanges("8:1-100000"))

grlist_lifted <- liftover_grlist(grlist = grlist,
                                 input_build = "hg19",
                                 output_build="hg38")
}
