% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather_files.R
\name{gather_files}
\alias{gather_files}
\title{Gather files}
\usage{
gather_files(
  dir,
  type = "peaks.stringent",
  nfcore_cutandrun = FALSE,
  return_paths = FALSE,
  rbind_list = FALSE,
  workers = check_workers(),
  verbose = TRUE
)
}
\arguments{
\item{dir}{Directory to search within.}

\item{type}{File type to search for. Options include:
\itemize{
\item{"<pattern>"}{Finds files matching an arbitrary regex pattern
specified by user.}
\item{"peaks.stringent"}{Finds files ending in "*.stringent.bed$"}
\item{"peaks.consensus"}{Finds files ending in "*.consensus.peaks.bed$"}
\item{"peaks.consensus.filtered"}{
Finds files ending in"*.consensus.peaks.filtered.awk.bed$"}
\item{"picard"}{Finds files ending in
"*.target.markdup.MarkDuplicates.metrics.txt$"}
}}

\item{nfcore_cutandrun}{Whether the files were generated by the
\href{https://nf-co.re/cutandrun}{nf-core/cutandrun} Nextflow pipeline.
 If \code{TRUE}, can use the standardised folder structure to
 automatically generate more descriptive file names with sample IDs.}

\item{return_paths}{Return only the file paths without actually reading them 
in as \link[GenomicRanges]{GRanges}.}

\item{rbind_list}{Bind all objects into one.}

\item{workers}{Number of cores to parallelise across 
(in applicable functions).
If \code{NULL}, will set to the total number of available cores minus 1.}

\item{verbose}{Print messages.}
}
\value{
A named list of \link[GenomicRanges]{GRanges} objects.
}
\description{
Recursively find peak/picard files stored within subdirectories and import
them as a list of \link[GenomicRanges]{GRanges} objects.
}
\details{
For "peaks.stringent" files called with 
\href{https://github.com/FredHutch/SEACR}{SEACR}, column names will be
automatically added:
\itemize{
\item{total_signal : }{Total signal contained within denoted coordinates.}
\item{max_signal}{Maximum bedgraph signal attained at any base pair 
 within denoted coordinates.}
\item{max_signal_region}{ Region representing the farthest upstream 
and farthest downstream bases within the denoted coordinates 
 that are represented by the maximum bedgraph signal.}
}
}
\examples{
#### Make example files ####
save_paths <- EpiCompare::write_example_peaks()
dir <- unique(dirname(save_paths))
#### Gather/import files ####
peaks <- EpiCompare::gather_files(dir=dir, 
                                  type="peaks.narrow",
                                  workers = 1)
}
