% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{draw_survival_curve}
\alias{draw_survival_curve}
\title{draw survival curve}
\usage{
draw_survival_curve(
  exp,
  living_days,
  living_events,
  write_name,
  title_name = "",
  threshold = NA,
  file = FALSE
)
}
\arguments{
\item{exp}{expression level for variable.}

\item{living_days}{The survival time (days) for each individual.}

\item{living_events}{The survival event for each individual, 0 indicates alive and 1 indicates death.
Other choices are TRUE/FALSE (TRUE = death) or 1/2 (2=death). For interval censored data, the status indicator is 0=right censored, 1=event at time, 2=left censored, 3=interval censored.}

\item{write_name}{The name for pdf file which contains the result figure.}

\item{title_name}{The title for the result figure.}

\item{threshold}{Threshold used to indicate the high risk or low risk.}

\item{file}{If True, function will automatic generate a result pdf, otherwise it will
return a ggplot object. Default is FALSE.}
}
\value{
This function will generate a pdf file with 300dpi which compare survival curves using the Kaplan-Meier (KM) test.
}
\description{
Draw a survival curve based on survminer package. This is a wrapper function of ggsurvplot.
}
\examples{
data(demo_survival_data)
library(survival)
demo_set<-create_demo()
draw_survival_curve(demo_set[1,],
    living_days = demo_survival_data[,1],
    living_events =demo_survival_data[,2],
    write_name = "demo_data" )

}
\author{
Xin Yu
}
