% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiffMCB.R
\name{DiffMCB}
\alias{DiffMCB}
\title{Differential expressed methylation correlated blocks}
\usage{
DiffMCB(
  methylation_matrix,
  class_vector,
  mcb_matrix = NULL,
  min.cpgsize = 5,
  pVals_num = 0.05,
  base_method = c("Fstat", "Tstat", "eBayes")[1],
  sec_method = c("ttest", "kstest")[1],
  ...
)
}
\arguments{
\item{methylation_matrix}{methylation profile matrix.}

\item{class_vector}{class vectors that indicated the groups.}

\item{mcb_matrix}{dataframe or matrix results returned by IdentifyMCB function.}

\item{min.cpgsize}{threshold for minimum CpGs must included in the individual MCBs.}

\item{pVals_num}{p value threshold for the test.}

\item{base_method}{base method used for calculation of differentially methylated regions,
should be one of 'Fstat','Tstat','eBayes'. Defualt is Fstat.}

\item{sec_method}{secondly method in attractor framework, should be one of 'kstest','ttest'. Defualt is ttest.}

\item{...}{other parameters pass to the function.}
}
\value{
Object of class \code{list} with elements:
 \tabular{ll}{
   \code{global} \tab Character set contains statistical value for all CpG sites in MCBs. \cr
   \code{tab} \tab Matrix contains the information of results. \cr
 }
}
\description{
This function is used to find the Methylation correlated blocks that differentially expressed between groups based on the attractor framework. 
This function calculates attractors of all the MCBs among the groups and find the attractor MCBs. \cr
}
\details{
Currently, only illumina 450k platform is supported. \cr
If you want to use other platform, please provide the annotation file with CpG's chromosome and loci. \cr
The methylation profile need to convert into matrix format.
}
\examples{
data('demo_data', package = "EnMCB")
data('demo_survival_data', package = "EnMCB")
data('demo_MCBinformation', package = "EnMCB")
#Using survival censoring as group label just for demo, 
#this may replace with disease and control group in real use.
diffMCB_results <- DiffMCB(demo_data$realdata,demo_survival_data[,2], 
                           demo_MCBinformation,
                           pVals_num = 1)

}
\references{
Xin Yu, De-Xin Kong, EnMCB: an R/bioconductor package for predicting disease progression based on methylation correlated blocks using ensemble models, Bioinformatics, 2021, btab415
}
\author{
Xin Yu
}
