% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_tt.R
\name{prepare_tt}
\alias{prepare_tt}
\title{Prepare differential gene expression table}
\usage{
prepare_tt(
  tt,
  tt_genecol = NULL,
  ttSpecies,
  output_species,
  method = "homologene",
  verbose = TRUE
)
}
\arguments{
\item{tt}{Differential expression table.
Can be output of \link[limma]{topTable} function.
Minimum requirement is that one column stores a metric of
increased/decreased expression (i.e. log fold change, t-statistic for
differential expression etc) and another contains gene symbols.}

\item{ttSpecies}{The species the differential expression table
was generated from.}

\item{output_species}{Species to convert \code{sct_data} and \code{hits} to
(Default: "human").
See \link[EWCE]{list_species} for all available species.}

\item{method}{R package to use for gene mapping:
\describe{
 \item{\code{"gprofiler"}}{Slower but more species and genes.}
 \item{\code{"homologene"}}{Faster but fewer species and genes.}
 \item{\code{"babelgene"}}{Faster but fewer species and genes.
 Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{verbose}{Print messages.}
}
\value{
List of 3 items
}
\description{
Prepare differential gene expression table for 
\link[EWCE]{generate_bootstrap_plots_for_transcriptome} or
\link[EWCE]{ewce_expression_data}.
}
\keyword{internal}
