% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ewce_genelist_input.r
\name{check_ewce_genelist_inputs}
\alias{check_ewce_genelist_inputs}
\title{check_ewce_genelist_inputs}
\usage{
check_ewce_genelist_inputs(
  sct_data,
  hits,
  bg = NULL,
  genelistSpecies = NULL,
  sctSpecies = NULL,
  sctSpecies_origin = sctSpecies,
  output_species = "human",
  method = "homologene",
  geneSizeControl = FALSE,
  standardise_sct_data = TRUE,
  standardise_hits = FALSE,
  min_genes = 4,
  verbose = TRUE
)
}
\arguments{
\item{sct_data}{List generated using \link[EWCE]{generate_celltype_data}.}

\item{hits}{List of gene symbols containing the target gene list.
Will automatically be converted to human gene symbols
if \code{geneSizeControl=TRUE}.}

\item{bg}{List of gene symbols containing the background gene list
(including hit genes). If \code{bg=NULL},
 an appropriate gene background will be created automatically.}

\item{genelistSpecies}{Species that \code{hits} genes came from
(no longer limited to just "mouse" and "human").
See \link[EWCE]{list_species} for all available species.}

\item{sctSpecies}{Species that \code{sct_data} is currently formatted as
(no longer limited to just "mouse" and "human").
See \link[EWCE]{list_species} for all available species.}

\item{sctSpecies_origin}{Species that the \code{sct_data} 
originally came from, regardless of its current gene format 
(e.g. it was previously converted from mouse to human gene orthologs).
 This is used for computing an appropriate backgrund.}

\item{output_species}{Species to convert \code{sct_data} and \code{hits} to
(Default: "human").
See \link[EWCE]{list_species} for all available species.}

\item{method}{R package to use for gene mapping:
\describe{
 \item{\code{"gprofiler"}}{Slower but more species and genes.}
 \item{\code{"homologene"}}{Faster but fewer species and genes.}
 \item{\code{"babelgene"}}{Faster but fewer species and genes.
 Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{geneSizeControl}{Whether you want to control for
GC content and transcript length. Recommended if the gene list originates
from genetic studies (\emph{Default: FALSE}).
If set to \code{TRUE}, then \code{hits} must be from humans.}

\item{standardise_sct_data}{Should \code{sct_data} be standardised? 
if \code{TRUE}:
\itemize{
\item{When \code{sctSpecies!=output_species}
 the \code{sct_data} will be checked for object formatting and 
 the genes will be converted to the orthologs of the \code{output_species} 
 with \link[EWCE]{standardise_ctd}
  (which calls \link[orthogene]{map_genes} internally).
}
\item{When \code{sctSpecies==output_species},
 the \code{sct_data} will be checked for object formatting 
 with  \link[EWCE]{standardise_ctd}, but the gene names 
 will remain untouched.
 }
}}

\item{standardise_hits}{Should \code{hits} be standardised? 
If \code{TRUE}:
\itemize{
\item{When \code{genelistSpecies!=output_species}, 
 the genes will be converted to the orthologs of the \code{output_species}
 with \link[orthogene]{convert_orthologs}.
 }
\item{When \code{genelistSpecies==output_species}, 
 the genes will be standardised with \link[orthogene]{map_genes}.
 }
} 
If \code{FALSE}, \code{hits} will be passed on to subsequent steps as-is.}

\item{min_genes}{Minimum number of genes in a gene list to test.}

\item{verbose}{Print messages.}
}
\value{
A list containing
\itemize{
  \item \code{hits}: Array of MGI/HGNC gene symbols containing the target
  gene list.
  \item \code{bg}: Array of MGI/HGNC gene symbols containing the background
  gene list.
}
}
\description{
\code{check_ewce_genelist_inputs} Is used to check that hits and bg gene
lists passed to EWCE are setup correctly. Checks they are the
appropriate length.
Checks all hits are in bg. Checks the species match and if not
reduces to 1:1 orthologs.
}
\examples{
ctd <- ewceData::ctd()
example_genelist <- ewceData::example_genelist()

# Called from "bootstrap_enrichment_test()" and "generate_bootstrap_plots()"
checkedLists <- EWCE::check_ewce_genelist_inputs(
    sct_data = ctd,
    hits = example_genelist,
    sctSpecies = "mouse",
    genelistSpecies = "human"
)
}
