% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_TPR_FPR.R
\name{ggplot2_TPR_FPRPlot}
\alias{ggplot2_TPR_FPRPlot}
\title{Plot TPR and FPR of each combination}
\usage{
ggplot2_TPR_FPRPlot(
  deg = NULL,
  count_table.filtered = NULL,
  stat = "mean",
  path = ".",
  save_plot = TRUE
)
}
\arguments{
\item{deg}{The list of DE genes generated by one of ERSSA::DE_*.R scripts.}

\item{count_table.filtered}{The filtered count table with non- and
low-expression genes removed. Used to identify the genes found to be non-DE.}

\item{stat}{The statistics used to summarize TPR and FPR at each replicate
level. Options include 'mean' and 'median'. Default = 'mean'.}

\item{path}{Path to which the plot will be saved. Default to current working
directory.}

\item{save_plot}{Boolean. Whether to save plot to drive. Default to TRUE.}
}
\value{
A list is returned containing:
 \itemize{
  \item{gg_object} {the ggplot2 object, which can then be further
  customized.}
  \item{TPR_FPR.dataframe} {the tidy table used for plotting.}
  \item{list_TP_FP_genes} {lists of TP and FP genes. Follow the format of
  deg object with each comb_n now as a list contain two vectors, one for
  each of TP and FP list of DE genes}
}
}
\description{
\code{ggplot2_TPR_FPR} function uses the full dataset list of DE genes as the
 ground truth to calculate the True Positive Rate (TPR) and False Positive
 Rate (FPR) for each sample combinations tested. The TPR and FPR are then
 plotted with FPR on x-axis and TPR on y-axis similar to a ROC curve.
}
\details{
Using the list of DE genes generated from the full dataset as the ground
truth should be done with caution. Since the true list of DE genes is not
known, this is the best alternative. This plot enables the visualization of
the sensitivity and (1-specificity) of the DE gene detection at the tested
replicate levels. At a sufficient replicate level, a relatively high TPR can
be reached with reasonable low FPR. Such a replicate level is sufficient for
most studies as additional replicates produce little improvement in TPR.
}
\examples{
# load edgeR deg object generated by erssa_edger using example dataset
# example dataset containing 1000 genes, 4 replicates and 5 comb. per rep.
# level
data(deg.partial, package = "ERSSA")
data(count_table.filtered.partial, package = "ERSSA")

gg_TPR_FPR = ggplot2_TPR_FPRPlot(deg.partial, count_table.filtered.partial)

}
\references{
H. Wickham. ggplot2: Elegant Graphics for Data Analysis.
Springer-Verlag New York, 2009.
}
\author{
Zixuan Shao, \email{Zixuanshao.zach@gmail.com}
}
