% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_cvmnull}
\alias{plot_cvmnull}
\title{Plot null distribution of permuted cvm scores vs. calculated cvm
scores.}
\usage{
plot_cvmnull(cvmobj)
}
\arguments{
\item{cvmobj}{An \code{\link{CVMomics}} object, typically returned via a call
to \code{\link{calculate_cvm}}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object is returned. If the value is
not assigned, a plot will be drawn.
}
\description{
The median of the randomly permuted CVM scores (i.e. the null
distribution) is plotted on the x-axis, vs. the observed CVM scores on the
y-axis. The line \code{y=x} is superimposed.
}
\examples{
# 100 genes, 100 samples
dat <- matrix(rnorm(10000), nrow=100, ncol=100)
rownames(dat) <- paste("gene", 1:100, sep="")
colnames(dat) <- paste("sample", 1:100, sep="")

# "group A" = first 50, "group B" = second 50
groups <- c(rep("A",50),rep("B",50))
names(groups) <- colnames(dat)

results <- calculate_cvm(dat, groups, nperm=10, parallel=FALSE)
plot_cvmnull(results)
}
\seealso{
\code{\link{calculate_cvm}} \code{\link[ggplot2]{ggplot}}
}

