% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CVM.R
\name{CVMomics}
\alias{CVMomics}
\title{Create an CVMomics object}
\usage{
CVMomics(data, outcomes, cvm, cvm.perm, pairwise.cvm.table, pairwise.q.table)
}
\arguments{
\item{data}{A matrix containing genomics data (e.g. gene expression levels).
The rownames should contain gene identifiers, while the column names should
contain sample identifiers.}

\item{outcomes}{A vector of group labels for each of the sample identifiers. The
names of this vector must correspond to the column names of \code{data}.}

\item{cvm}{A matrix containing a row for each gene in \code{data}, and with
the following columns:
\itemize{
\item \code{cvm} The calculated cvm score.
\item \code{q-value} The calculated q-value.
}
The row names should specify the gene identifiers for each row.}

\item{cvm.perm}{A matrix containing a row for each gene in \code{data}, and
with a column containing cvm scores for each random permutation calculated
via \code{\link{calculate_cvm}}.}

\item{pairwise.cvm.table}{A table containing the CVM scores for each pairwise
comparison for each gene. For a two-class problem, there should be only one column
comparing class 1 and class 2. The row names should be gene identifiers. The column
names should be in the format "<class 1> vs <class 2>" (e.g. "1 vs 2" or "A vs B").}

\item{pairwise.q.table}{A table containing the permutation-based q-values for each
pairwise comparison for each gene. May be \code{NULL} if \code{pairwise.p=F}.}
}
\value{
The function combines its arguments in a list, which is assigned class
'CVMomics'. The resulting object is returned.
}
\description{
This is the constructor for objects of class 'CVMomics'. It
is used in \code{\link{calculate_cvm}} to construct the return value.
}
\seealso{
\code{\link{calculate_cvm}}
}

