% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density_compare.R
\name{plot_density_compare}
\alias{plot_density_compare}
\title{Plot density comparisons}
\usage{
plot_density_compare(
  aucA,
  aucB,
  col = "lightgrey",
  xlab = "AUROC (neighbor voting)",
  ylab = "Density",
  mode = TRUE
)
}
\arguments{
\item{aucA}{numeric array of aurocs}

\item{aucB}{numeric array of aurocs}

\item{col}{color of lines}

\item{xlab}{string label}

\item{ylab}{string label}

\item{mode}{boolean to plot mode or mean}
}
\value{
null
}
\description{
The function plots two density curves and compares their modes
}
\examples{
aurocsA <- (runif(1000)+runif(1000)+runif(1000)+runif(1000))/4
aurocsB <- runif(1000)
plot_density_compare(aurocsA, aurocsB)

}
\keyword{plot}
