% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_preproc.R
\name{runDuplexDiscoPreproc}
\alias{runDuplexDiscoPreproc}
\title{Run pre-processing of chimeric reads input}
\usage{
runDuplexDiscoPreproc(
  data,
  table_type,
  library_type = "SE",
  keep_metadata = TRUE,
  return_gi = FALSE,
  min_arm_len = 15
)
}
\arguments{
\item{data}{Either dataframe-like object: \emph{Chimeric.out.junction} from \emph{STAR} or
\emph{.bedpe} - formatted or \code{GInteractions} object from \pkg{InteractionSet} package}

\item{table_type}{in \code{c("STAR","bedpe")} for Chimeric.out.Junction or generic input}

\item{library_type}{\code{c("SE","PE")} for pair- or single- end input}

\item{keep_metadata}{\code{c(TRUE,FALSE)} Whether extra fields like
CIGAR strings and junction coordinates should be kept}

\item{return_gi}{if the return object should be \code{GInteractions}}

\item{min_arm_len}{minimum allowed length of the alignment arm.
Read will be dropped if either arm is shorter}
}
\value{
tibble with new metadata fields OR GInteractions if \code{return_gi} is
set to TRUE
}
\description{
Imports dataframe with reads (\emph{.bedpe} or \emph{Chimeric.out.junction} ) or \code{GInteractions}
object.
Checks column names or tries to quess them if not provided.
Adds necessary annotation depending on the input type,
For \emph{STAR} input, calculates length of the alignments
and marks unique 2-arm alignments.
For the \emph{.bedpe} or \code{GInteractions} input, all entries are already represented as reads
with two different aligned parts (2-arm), so only check for unique readname
is performed.
}
\details{
If not existed, adds fields required for the downstream steps:
'readname', 'map_type', 'score', 'n_reads'.
'map_type' field determines the type of the chimeric read:
\describe{
\item{multimap}{ multi-mapped read}
\item{multigap}{ more than one junction (more than two 'N' in CIGAR string)}
\item{bad junction}{ Artifacts or possibly unaccounted types.
I.e alignments for both arms are continuous, but with 'backward' chimeric
junction was wrongly introduced in the mapping}
}
}
\examples{
# load data
data(RNADuplexesSampleData)
# with bedpe input
preproc_reads <- runDuplexDiscoPreproc(RNADuplexesRawBed, table_type = "bedpe")
# with STAR input
preproc_reads_star <- runDuplexDiscoPreproc(RNADuplexesRawChimSTAR,
    table_type = "STAR",
    keep_metadata = FALSE
)
}
