% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ_phyloseq_sampleID.R
\name{summ_phyloseq_sampleID}
\alias{summ_phyloseq_sampleID}
\title{Generate Summary Statistics for Each Sample}
\usage{
summ_phyloseq_sampleID(obj)
}
\arguments{
\item{obj}{A \code{phyloseq} or \code{TreeSummarizedExperiment} object containing microbiome data.}
}
\value{
A data frame containing summary statistics per sample, with columns:
\itemize{
\item Sample_ID
\item Mean
\item Median
\item Standard Deviation (SD)
\item Standard Error (SE)
\item Q25 (25th percentile)
\item Q50 (Median)
\item Q75 (75th percentile)
}
}
\description{
Calculates summary statistics (mean, median, standard deviation, standard error, and quartiles)
for each sample in a \code{phyloseq} or \code{TreeSummarizedExperiment} object.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")

  # Summarize the phyloseq object
  summary_stats_physeq <- summ_phyloseq_sampleID(physeq_16SOTU)
  print(summary_stats_physeq)

  # Convert to TreeSummarizedExperiment
  tse_16SOTU <- convert_phyloseq_to_tse(physeq_16SOTU)
  summary_stats_tse <- summ_phyloseq_sampleID(tse_16SOTU)
  print(summary_stats_tse)
}

}
