% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization_set.R
\name{normalization_set}
\alias{normalization_set}
\title{Apply the Selected Normalization Method to the Phyloseq and TSE Objects}
\usage{
normalization_set(obj, method, groups = NULL)
}
\arguments{
\item{obj}{A phyloseq object.}

\item{method}{A character string specifying the normalization method ("TC", "UQ", "med", "DESeq", "Poisson", "QN", "TMM", "clr", "rar", "css", "tss", "rle").}

\item{groups}{A column name of group labels from sample data.}
}
\value{
A list containing the normalized phyloseq object and scaling factors.
}
\description{
Apply the Selected Normalization Method to the Phyloseq and TSE Objects
}
\examples{
# Example with a phyloseq object
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")
  ps <- physeq_16SOTU
  result_phyloseq <- normalization_set(ps, method = "TC", groups = "Host.species")
  head(result_phyloseq$scaling.factor)
  normed_physeq <- result_phyloseq$dat.normed
}

# Example with a TreeSummarizedExperiment (TSE) object
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")
  tse_16SOTU <- convert_phyloseq_to_tse(physeq_16SOTU)
  result_tse <- normalization_set(tse_16SOTU, method = "clr")
  head(result_tse$scaling.factor)
  normed_tse <- result_tse$dat.normed
}

# For a full comparison of all normalization methods, see the vignette:
# vignette("DspikeIn-with-Phyloseq", package = "DspikeIn")
# vignette("DspikeIn-with-TSE", package = "DspikeIn")

}
