% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_tse_to_phyloseq.R
\name{convert_tse_to_phyloseq}
\alias{convert_tse_to_phyloseq}
\title{Convert a \code{TreeSummarizedExperiment} to a \code{phyloseq} Object}
\usage{
convert_tse_to_phyloseq(tse)
}
\arguments{
\item{tse}{A \code{TreeSummarizedExperiment} object, expected to contain:
\itemize{
\item OTU abundance matrix (assay named \code{"counts"}).
\item Taxonomy data (as \code{rowData}).
\item Sample metadata (as \code{colData}).
\item Optional phylogenetic tree (from \code{rowTree()}).
\item Optional reference sequences (\code{referenceSeq()} accessor).
}}
}
\value{
A \code{phyloseq} object with all available components (\code{otu_table}, \code{tax_table},
\code{sample_data}, \code{phy_tree}, \code{refseq}) populated accordingly.
}
\description{
Converts a \code{TreeSummarizedExperiment} (TSE) object into a \code{phyloseq} object,
preserving key components such as the OTU table, taxonomy, sample metadata, phylogenetic tree,
and reference sequences (if present). This enables seamless interoperability between Bioconductor
and \code{phyloseq} workflows.
}
\examples{
if (requireNamespace("DspikeIn", quietly = TRUE)) {
  data("physeq_16SOTU", package = "DspikeIn")

  # Convert to TSE and back to phyloseq
  tse <- convert_phyloseq_to_tse(physeq_16SOTU)
  phy <- convert_tse_to_phyloseq(tse)
  print(phy)
}
}
