% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffSeqLogoSupport.R
\name{calculatePvalue}
\alias{calculatePvalue}
\title{p-value that two PWM-positions are from the same distribution}
\usage{
calculatePvalue(p1, p2, n1, n2, stackHeight = shannonDivergence,
  numberOfPermutations = 100, plotGammaDistributionFit = FALSE)
}
\arguments{
\item{p1}{first probability vector with one probability for each symbol of the alphabet}

\item{p2}{second probability vector with one probability for each symbol of the alphabet}

\item{n1}{number of observations for the calculation of p1}

\item{n2}{number of observations for the calculation of p2}

\item{stackHeight}{function for the calculation of a divergence measure for two probability vectors}

\item{numberOfPermutations}{the number of permutations to perform for the calculation of stackHeights}

\item{plotGammaDistributionFit}{if TRUE the fit of a gamma distribution to the sampled stackHeights is plotted}
}
\value{
a numeric p-value
}
\description{
Calculates the p-value for the null-hypothesis that two given probability vectors p1, p2 calculated from n1/n2 observations arise from the same distribution
}
\examples{
p1 <- c(0.2, 0.3, 0.1, 0.4)
p2 <- c(0.2, 0.1, 0.3, 0.4)
n1 <- 100
n2 <- 200
numberOfPermutations = 100
plotGammaDistributionFit = TRUE

pValue <- calculatePvalue(p1 = p1, p2 = p2, n1 = n1, n2 = n2, stackHeight = shannonDivergence, numberOfPermutations = numberOfPermutations, plotGammaDistributionFit = plotGammaDistributionFit)
}
\author{
Hendrik Treutler
}
