% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomPoisArray-class.R
\docType{class}
\name{RandomPoisArray-class}
\alias{RandomPoisArray-class}
\alias{RandomPoisArraySeed-class}
\alias{RandomPoisMatrix-class}
\alias{sampleDistrParam,RandomPoisArraySeed-method}
\alias{sampleDistrFun,RandomPoisArraySeed-method}
\alias{matrixClass,RandomPoisArray-method}
\alias{RandomPoisArraySeed}
\alias{DelayedArray,RandomPoisArraySeed-method}
\alias{RandomPoisArray}
\title{DelayedArray of random Poisson values}
\usage{
RandomPoisArraySeed(dim, lambda, chunkdim = NULL, sparse = FALSE)

\S4method{DelayedArray}{RandomPoisArraySeed}(seed)

RandomPoisArray(dim, lambda, chunkdim = NULL, sparse = FALSE)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{lambda}{Numeric vector used as \code{lambda} in \code{\link{qpois}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{sparse}{Logical scalar indicating whether the sampled array should be treated as sparse.}

\item{seed}{A RandomPoisArraySeed object.}
}
\value{
All constructors return an instance of a RandomPoisArray object,
containing random draws from a Poisson distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of Poisson-distributed values.
}
\examples{
X <- RandomPoisArraySeed(c(1e5, 1e5), lambda=2)
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomPoisArraySeed(c(1e5, 1e5), lambda=runif(1e5), sparse=TRUE)
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
lambda <- rsparsematrix(1e5, 1e5, density=0.00001)
lambda <- abs(DelayedArray(lambda)) + 0.1
X3 <- RandomPoisArraySeed(c(1e5, 1e5), lambda=lambda)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
