% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomNormArray-class.R
\docType{class}
\name{RandomNormArray-class}
\alias{RandomNormArray-class}
\alias{RandomNormArraySeed-class}
\alias{RandomNormMatrix-class}
\alias{sampleDistrParam,RandomNormArraySeed-method}
\alias{sampleDistrFun,RandomNormArraySeed-method}
\alias{matrixClass,RandomNormArray-method}
\alias{RandomNormArraySeed}
\alias{DelayedArray,RandomNormArraySeed-method}
\alias{RandomNormArray}
\title{DelayedArray of random normal values}
\usage{
RandomNormArraySeed(dim, mean = 0, sd = 1, chunkdim = NULL)

\S4method{DelayedArray}{RandomNormArraySeed}(seed)

RandomNormArray(dim, mean = 0, sd = 1, chunkdim = NULL)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{mean, sd}{Numeric vector used as \code{mean} and \code{sd}, respectively, in \code{\link{qnorm}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{seed}{A RandomNormArraySeed object.}
}
\value{
All constructors return an instance of a RandomNormArray object,
containing random draws from a normal distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of normally distributed values.
}
\examples{
X <- RandomNormArraySeed(c(1e5, 1e5))
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomNormArraySeed(c(1e5, 1e5), mean=runif(1e5), sd=runif(1e5))
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
mean <- rsparsematrix(1e5, 1e5, density=0.00001)
X3 <- RandomNormArraySeed(c(1e5, 1e5), mean=mean)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
