% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomNbinomArray-class.R
\docType{class}
\name{RandomNbinomArray-class}
\alias{RandomNbinomArray-class}
\alias{RandomNbinomArraySeed-class}
\alias{RandomNbinomMatrix-class}
\alias{sampleDistrParam,RandomNbinomArraySeed-method}
\alias{sampleDistrFun,RandomNbinomArraySeed-method}
\alias{matrixClass,RandomNbinomArray-method}
\alias{extract_array,RandomNbinomArraySeed-method}
\alias{RandomNbinomArraySeed}
\alias{DelayedArray,RandomNbinomArraySeed-method}
\alias{RandomNbinomArray}
\title{DelayedArray of random negative binomial values}
\usage{
RandomNbinomArraySeed(
  dim,
  prob = prob,
  size = size,
  mu = mu,
  chunkdim = NULL,
  sparse = FALSE
)

\S4method{DelayedArray}{RandomNbinomArraySeed}(seed)

RandomNbinomArray(dim, prob, size, mu, chunkdim = NULL, sparse = FALSE)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{prob, size, mu}{Numeric vector used as the argument of the same name in \code{\link{qnbinom}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.

Exactly one of \code{prob} or \code{mu} should be supplied.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{sparse}{Logical scalar indicating whether the sampled array should be treated as sparse.}

\item{seed}{A RandomNbinomArraySeed object.}
}
\value{
All constructors return an instance of a RandomNbinomArray object,
containing random draws from a negative binomial distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of negative binomial-distributed values.
}
\examples{
X <- RandomNbinomArraySeed(c(1e5, 1e5), size=10, mu=20)
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomNbinomArraySeed(c(1e5, 1e5), size=10, mu=runif(1e5), sparse=TRUE)
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
lambda <- rsparsematrix(1e5, 1e5, density=0.00001)
lambda <- abs(DelayedArray(lambda)) + 0.1
X3 <- RandomNbinomArraySeed(c(1e5, 1e5), size=1, mu=lambda)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
