% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomChisqArray-class.R
\docType{class}
\name{RandomChisqArray-class}
\alias{RandomChisqArray-class}
\alias{RandomChisqArraySeed-class}
\alias{RandomChisqMatrix-class}
\alias{sampleDistrParam,RandomChisqArraySeed-method}
\alias{sampleDistrFun,RandomChisqArraySeed-method}
\alias{matrixClass,RandomChisqArray-method}
\alias{extract_array,RandomChisqArraySeed-method}
\alias{RandomChisqArraySeed}
\alias{DelayedArray,RandomChisqArraySeed-method}
\alias{RandomChisqArray}
\title{DelayedArray of random chi-squared-distributed values}
\usage{
RandomChisqArraySeed(dim, df, ncp = 0, chunkdim = NULL)

\S4method{DelayedArray}{RandomChisqArraySeed}(seed)

RandomChisqArray(dim, df, ncp = 0, chunkdim = NULL)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{df, ncp}{Numeric vector used as the argument of the same name in \code{\link{qchisq}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{seed}{A RandomChisqArraySeed object.}
}
\value{
All constructors return an instance of a RandomChisqArray object,
containing random draws from a chi-squared distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of chi-squared-distributed values.
}
\examples{
X <- RandomChisqArraySeed(c(1e5, 1e5), df=5)
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomChisqArraySeed(c(1e5, 1e5), df=runif(1e5)*20)
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
df <- rsparsematrix(1e5, 1e5, density=0.00001)
df <- abs(DelayedArray(df) + 1) * 10
X3 <- RandomChisqArraySeed(c(1e5, 1e5), df=df)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
