% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degCreCore.R
\name{correctAssocProbs}
\alias{correctAssocProbs}
\title{Correct Association Probabilities}
\usage{
correctAssocProbs(sortHitsDf, assocProbs, refAssocProbs = NULL)
}
\arguments{
\item{sortHitsDf}{A \link[S4Vectors]{DataFrame} containing sorted hits data.}

\item{assocProbs}{A numeric vector of association probabilities.}

\item{refAssocProbs}{A numeric vector of reference association
probabilities. (Default: \code{NULL}, uses \code{assocProbs} if \code{NULL})}
}
\value{
A numeric vector of corrected association probabilities.
}
\description{
This function corrects association probabilities based on distance bins and
reference association probabilities.
}
\details{
Not exported. This function corrects association probabilities within the
same distance bin based on reference association probabilities in lower
distance bins. It calculates adjusted association probabilities and
reference association probabilities for each distance bin and updates the
original association probabilities accordingly.
The principle is that for all associations involving a single CRE, those
associations to significant DEGs that span the shortest distances should be
weighted higher than those that span farther distances.
It is meant to run within \link{runDegCre}. It will not run well on
unintended inputs.
}
\examples{
\dontrun{
# Distance bin correct association probabilities.
correctedProbs <- correctAssocProbs(sortHitsDf = mySortedHits,
                                    assocProbs = myAssocProbs,
                                    refAssocProbs = myRefAssocProbs)
}

}
\author{
Brian S. Roberts
}
\keyword{internal}
