% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Feature_Selection.R
\name{DaMiR.FSort}
\alias{DaMiR.FSort}
\title{Order features by importance, using RReliefF filter}
\usage{
DaMiR.FSort(data, df, fSample = 1)
}
\arguments{
\item{data}{A transposed data frame of expression data, i.e.
transformed
counts by vst or rlog. A log2 transformed expression matrix is also
 accepted.
Rows and Cols should be, respectively, observations and features}

\item{df}{A data frame with class and known variables; at least one
column with
'class' label must be included}

\item{fSample}{Fraction of sample to be used for the implementation
of RReliefF algorithm; default is 1}
}
\value{
A data frame with two culmuns, where features are sorted by
importance scores:
\itemize{
  \item RReliefF score - Calculated by \code{\link{relief}} function,
   implemented in
  \code{FSelector} package;
  \item scaled.RReliefF  score - Z-score value, computed for each
  RReliefF score.
}
A plot with the first 50 features ordered by their importance.
}
\description{
This function implements a procedure in order to rank
 features by their
importance evaluated by RReliefF score.
}
\details{
This function is very time-consuming when the number of
features is
high. We observed there is a quadratic relationship between execution
 time
and the number of features. Thus, we have also implemented a formula
 which allows
the users to estimate the time to perform this step, given the number
 of features.
The formula is:
\deqn{T = 0.0011 * N^2 - 0.1822 * N + 27.092}
where T = Time and N = Number of genes.
We strongly suggest to filter out non informative features before
performing
this step.
}
\examples{
# use example data:
data(data_reduced)
data(df)
# rank features by importance:
df.importance <- DaMiR.FSort(data_reduced[,1:10],
 df, fSample = 0.75)

}
\references{
Marko Robnik-Sikonja, Igor Kononenko: An adaptation of Relief for
attribute
estimation in regression. In: Fourteenth International Conference
on Machine
Learning, 296-304, 1997
}
\seealso{
\code{\link{relief}}, \code{\link{DaMiR.FSelect}},
 \code{\link{DaMiR.FReduct}}
}
\author{
Mattia Chiesa, Luca Piacentini
}
