% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DO.Import.R
\name{.QC_Vlnplot}
\alias{.QC_Vlnplot}
\title{.QC_Vlnplot}
\usage{
.QC_Vlnplot(
  sce_object,
  id,
  layer = "counts",
  features = c("nFeature_RNA", "nCount_RNA", "pt_mito")
)
}
\arguments{
\item{sce_object}{A Seurat object containing single-cell RNA-seq data.}

\item{layer}{A character string specifying the assay layer to use
(default is "counts").}

\item{features}{A character vector of length 3 indicating the feature names
to plot. Default is c("nFeature_RNA", "nCount_RNA", "pt_mito").}
}
\value{
A \code{ggplot} object arranged in a single row showing violin plots for
the specified features with overlaid boxplots.
}
\description{
Generates violin plots for common quality control (QC) metrics of single-cell
RNA-seq data from a Seurat object. The function displays three violin plots
for the number of detected genes per cell (\code{nFeature_RNA}), total UMI counts
per cell (\code{nCount_RNA}), and mitochondrial gene content percentage
(\code{pt_mito}). Useful for visual inspection of QC thresholds and outliers.
}
\author{
Mariano Ruz Jurado
}
\keyword{internal}
