% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DO.Integration.R
\name{DO.Integration}
\alias{DO.Integration}
\title{DO.Integration SCE object integration directly}
\usage{
DO.Integration(
  sce_object,
  split_key = "orig.ident",
  HVG = FALSE,
  scale = FALSE,
  pca = FALSE,
  neighbors = TRUE,
  neighbors_dim = seq_len(50),
  clusters = TRUE,
  clusters_res = 0.3,
  clusters_algorithm = 4,
  umap = TRUE,
  umap_key = "UMAP",
  umap_dim = seq_len(50),
  integration_method = "CCAIntegration",
  selection_method = "vst",
  loess_span = 0.3,
  clip_max = "auto",
  num_bin = 20,
  binning_method = "equal_width",
  scale_max = 10,
  pca_key = "PCA",
  integration_key = "INTEGRATED.CCA",
  npcs = 50,
  verbose = FALSE
)
}
\arguments{
\item{sce_object}{Seurat or SCE Object}

\item{split_key}{Character. Column in meta data to split the samples by,
default orig.ident}

\item{HVG}{Logical. Perform detection of highly variable genes}

\item{scale}{Logical. Perform scaling of the expression data}

\item{pca}{Logical. Perform principal component analysis}

\item{neighbors}{Logical. Perform Nearest-neighbor graph after integration}

\item{neighbors_dim}{Numeric range. Dimensions of reduction to use as input}

\item{clusters}{Logical. Perform clustering of cells}

\item{clusters_res}{Numeric. Value of the resolution parameter, use a value
above (below) 1.0 if you want to obtain a larger (smaller) number of
communities.}

\item{clusters_algorithm}{Numeric. Define the algorithm for clustering,
default 4 for "Leiden"}

\item{umap}{Logical. Runs the Uniform Manifold Approximation and Projection}

\item{umap_key}{Character name for}

\item{umap_dim}{Numeric range. Which dimensions to use as input features}

\item{integration_method}{Character. Define the integration method, please
check what versions are supported in Seurat::IntegrateLayers function}

\item{selection_method}{Character. Default "vst". Options: "mean.var.plot",
"dispersion"}

\item{loess_span}{Numeric. Loess span parameter used when fitting the
variance-mean relationship}

\item{clip_max}{Character. After standardization values larger than clip.max
will be set to clip.max; default is 'auto' which sets this value to the
square root of the number of cells}

\item{num_bin}{Numeric. Total number of bins to use in the scaled analysis
(default is 20)}

\item{binning_method}{Character. “equal_width”: each bin is of equal width
along the x-axis (default). Options: “equal_frequency”:}

\item{scale_max}{Numeric. Max value to return for scaled data. The default
is 10.}

\item{pca_key}{Character. Key name to save the pca result in}

\item{integration_key}{Character. Key name to save the integration result in}

\item{npcs}{Numeric. Total Number of PCs to compute and store (50 by default)}

\item{verbose}{Logical. Verbosity for all functions}
}
\value{
integrated sce/seurat object
}
\description{
Integrates single-cell RNA-seq data directly from
SingleCellExperiment or Seurat objects. Supports detection of variable genes
, scaling, PCA, neighbor graph construction, clustering, and UMAP embedding,
with multiple integration methods.
}
\examples{
sce_data <-
    readRDS(system.file("extdata", "sce_data.rds", package = "DOtools"))

DO.Integration(
    sce_object = sce_data,
    split_key = "orig.ident",
    HVG = TRUE,
    scale = TRUE,
    pca = TRUE,
    integration_method = "CCAIntegration"
)

}
\author{
Mariano Ruz Jurado
}
