% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{numSamples}
\alias{numSamples}
\alias{numSamples,DNEA-method}
\alias{numSamples,DNEAinputSummary-method}
\title{Retrieves the total number of samples in the dataset}
\usage{
numSamples(x)

\S4method{numSamples}{DNEA}(x)

\S4method{numSamples}{DNEAinputSummary}(x)
}
\arguments{
\item{x}{A \code{\link{DNEA}} object.}
}
\value{
The number of samples in the data set.
}
\description{
This function prints to console the total number of
samples in the data set.
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

numSamples(dnw)
}
\seealso{
\code{\link{createDNEAobject}}
}
\author{
Christopher Patsalis
}
