% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{networkGroups}
\alias{networkGroups}
\alias{networkGroups,DNEA-method}
\title{Retrieve the unique group values of the experimental condition}
\usage{
networkGroups(x)

\S4method{networkGroups}{DNEA}(x)
}
\arguments{
\item{x}{A \code{\link{DNEA}} or
\code{\link{collapsed_DNEA}}}
}
\value{
A vector of the condition values.
}
\description{
This function takes in a \code{\link{DNEA}} object and
returns the unique group labels of the experimental
condition in the data set.
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

networkGroups(dnw)
}
\seealso{
\code{\link{networkGroupIDs}},
\code{\link{createDNEAobject}}
}
\author{
Christopher Patsalis
}
