% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities-exported.R
\name{includeMetadata}
\alias{includeMetadata}
\title{Add additional metadata to the DNEA object}
\usage{
includeMetadata(object, type = c("samples", "features"), metadata)
}
\arguments{
\item{object}{A \code{\link[=DNEA-class]{DNEA}} object.}

\item{type}{A character string corresponding to the type of metadata
being included. Can be either "samples" or "features"}

\item{metadata}{a data frame containing metadata to add. The row
names should be either the sample names or feature names, respectively}
}
\value{
A \code{\link[=DNEA-class]{DNEA}} object with the specified additions.
}
\description{
This function will take additional metadata and add it to the specified
data frame in the metadata slot. \strong{\emph{NOTE:}} The row names
of the new metadata must match the order of the input sample names
or feature names, respectively.
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

#make sure metadata has same sample order as DNEA object
T1Dmeta <- T1Dmeta[sampleNames(dnw), ]

#add new metadata to DNEA object
dnw <- includeMetadata(object=dnw, type="samples", metadata=T1Dmeta)

}
\seealso{
\code{\link{featureNames}},\code{\link{sampleNames}},
\code{\link{metaData}}
}
\author{
Christopher Patsalis
}
