% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{datasetSummary}
\alias{datasetSummary}
\alias{datasetSummary,DNEA-method}
\title{Access the dataset_summary slot of a DNEA object}
\usage{
datasetSummary(x)

\S4method{datasetSummary}{DNEA}(x)
}
\arguments{
\item{x}{A \code{\link{DNEA}} object.}
}
\value{
The numbers of samples/features and diagnostic values
of the input data stored in the dataset_summary slot of the
\code{\link{DNEA}}.
}
\description{
This function prints to console the number of samples, number of
features, and diagnostic values of the input data stored in the
dataset_summary slot of the \code{\link{DNEA}}.
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

datasetSummary(dnw)
}
\seealso{
\code{\link{createDNEAobject}},\code{\link{aggregateFeatures}}
}
\author{
Christopher Patsalis
}
