% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadData.R
\name{readBismarkPool}
\alias{readBismarkPool}
\title{Read Bismark pool}
\usage{
readBismarkPool(files)
}
\arguments{
\item{files}{The filenames (including path) of the methylation
(CX report generated with Bismark) to be read}
}
\value{
the methylation data stored as a \code{\link{GRanges}}
object with four metadata columns (see \code{\link{methylationDataList}}).
}
\description{
This function takes as input a vector of CX report file produced by Bismark
and returns a \code{\link{GRanges}} object with four metadata columns
(see \code{\link{methylationDataList}}). The file represents the pooled
bisulfite sequencing data.
}
\examples{

# load methylation data object
data(methylationDataList)

# save the two datasets
saveBismark(methylationDataList[["WT"]],
           "chr3test_a_thaliana_wt.CX_report")
saveBismark(methylationDataList[["met1-3"]],
           "chr3test_a_thaliana_met13.CX_report")

# reload the two datasets and pool them
filenames <- c("chr3test_a_thaliana_wt.CX_report",
               "chr3test_a_thaliana_met13.CX_report")
methylationDataPool <- readBismarkPool(filenames)

}
\author{
Nicolae Radu Zabet and Jonathan Michael Foonlan Tsang
}
