% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individual_svg.R
\name{individual_svg}
\alias{individual_svg}
\title{individual_svg}
\usage{
individual_svg(
  spe,
  cluster_col,
  sample_col = "sample_id",
  edgeR_y = NULL,
  min_counts = 20,
  min_non_zero_spots = 10,
  filter_gene = TRUE,
  replicates = FALSE,
  BPPARAM = NULL
)
}
\arguments{
\item{spe}{SpatialExperiment or SingleCellExperiment.}

\item{cluster_col}{Column name of spatial clusters in \code{colData(spe)}.}

\item{sample_col}{Column name of sample ids in \code{colData(spe)}.}

\item{edgeR_y}{Pre-estimated dispersion; if it's null, compute dispersion.}

\item{min_counts}{Minimum number of counts per sample (across all spots) for a gene to be analyzed.}

\item{min_non_zero_spots}{Minimum number of non-zero spots per sample, for a gene to be analyzed.}

\item{filter_gene}{A logical. If TRUE, 
\code{\link{svg_test}} filters genes:
genes have to be expressed in at least 'min_non_zero_spots' spots, 
and a gene requires at least 'min counts' counts per sample (across all locations).}

\item{replicates}{Single sample or multi-sample test.}

\item{BPPARAM}{An optional parameter passed internally to bplapply.
We suggest using as many cores as the number of spatial clusters.
If unspecified, the script does not run in parallel.
Note that parallel coding performs better only when 
dispersion estimations are not provided beforehand.
Moreover, parallelizing the script will increase the memory requirement;
if memory is an issue, leave 'BPPARAM' unspecified and, hence, avoid parallelization.}
}
\value{
A list of results, with one result per spatial cluster in each element.
Specifically, each item in the list is a "gene_results" dataframe which contains main edgeR test results.
}
\description{
DESpace can also be used to reveal the specific areas of the tissue affected by SVGs; i.e., spatial clusters that are particularly over/under abundant compared to the average signal.
This function can be used to identify SVGs for each individual cluster.
}
\details{
For every spatial cluster we test, \code{edgeR} would normally re-compute the dispersion estimates based on the specific design of the test.
However, this calculation represents the majority of the overall computing time.
Therefore, to speed-up calculations, we propose to use the dispersion estimates which were previously computed for the gene-level tests.
This introduces a minor approximation which, in our benchmarks, does not lead to decreased accuracy.
If you want to use pre-computed gene-level dispersion estimates, set \code{edgeR_y} to 'estimated_y'.
Alternatively, if you want to re-compute dispersion estimates (significantly slower, but marginally more accurate option), leave edgeR_y empty.
}
\examples{
# load the input data:
data("LIBD_subset", package = "DESpace")
LIBD_subset

# load pre-computed results (obtaines via `svg_test`)
data("results_svg_test", package = "DESpace")

# svg_test returns of a list of 2 objects:
# "gene_results": a dataframe contains main edgeR test results;
# "estimated_y": a DGEList object contains the estimated common dispersion, 
#  which can later be used to speed-up calculation when testing individual clusters.

# We visualize differential results:
head(results_svg_test$gene_results, 3)

# Individual cluster test: identify SVGs for each individual cluster
# set parallel computing; we suggest using as many cores as the number of spatial clusters.
# Note that parallelizing the script will increase the memory requirement;
# if memory is an issue, leave 'BPPARAM' unspecified and, hence, avoid parallelization.
set.seed(123)
results_individual_svg <- individual_svg(LIBD_subset, 
                                         edgeR_y = results_svg_test$estimated_y, 
                                         cluster_col = "layer_guess_reordered")
                                           
# We visualize results for the cluster 'WM'
results_WM <- results_individual_svg[[7]]
head(results_WM,3)

}
\seealso{
\code{\link{top_results}}, \code{\link{svg_test}}, \code{\link{FeaturePlot}}
}
