% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_functions.R
\name{report}
\alias{report}
\title{Generate a markdown report}
\usage{
report(results)
}
\arguments{
\item{results}{List of SummarizedExperiment objects obtained
from the \code{\link{LFQ}} or \code{\link{TMT}} wrapper functions.}
}
\value{
A \code{\link[rmarkdown:rmarkdown-package]{rmarkdown}} report is generated and saved.
Additionally, the results table is saved as a tab-delimited txt file.
}
\description{
\code{report} generates a report of the analysis performed
by \code{\link{TMT}} and \code{\link{LFQ}} wrapper functions.
Additionally, the results table is saved as a tab-delimited file.
}
\examples{
\dontrun{

data <- UbiLength
expdesign <- UbiLength_ExpDesign

results <- LFQ(data, expdesign, 'MinProb', 'control', 'Ctrl')
report(results)

}
}
