% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_results.R
\name{plot_single}
\alias{plot_single}
\title{Plot values for a protein of interest}
\usage{
plot_single(dep, proteins, type = c("contrast", "centered"), plot = TRUE)
}
\arguments{
\item{dep}{SummarizedExperiment,
Data object for which differentially enriched proteins are annotated
(output from \code{\link{test_diff}()} and \code{\link{add_rejections}()}).}

\item{proteins}{Character,
The name(s) of the protein(s) to plot.}

\item{type}{'contrast' or 'centered',
The type of data scaling used for plotting.
Either the fold change ('contrast') or
the centered log2-intensity ('centered').}

\item{plot}{Logical(1),
If \code{TRUE} (default) the barplot is produced.
Otherwise (if \code{FALSE}), the summaries which the
barplot is based on are returned.}
}
\value{
A barplot (generated by \code{\link[ggplot2]{ggplot}}).
}
\description{
\code{plot_single} generates a barplot of a protein of interest.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter, normalize and impute missing values
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)
imputed <- impute(norm, fun = "MinProb", q = 0.01)

# Test for differentially expressed proteins
diff <- test_diff(imputed, "control", "Ctrl")
dep <- add_rejections(diff, alpha = 0.05, lfc = 1)

# Plot single proteins
plot_single(dep, 'USP15')
plot_single(dep, 'USP15', 'centered')
plot_single(dep, c('USP15', 'CUL1'))
plot_single(dep, c('USP15', 'CUL1'), plot = FALSE)
}
