% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_frequencies.R
\name{plot_numbers}
\alias{plot_numbers}
\title{Plot protein numbers}
\usage{
plot_numbers(se, plot = TRUE)
}
\arguments{
\item{se}{SummarizedExperiment,
Data object for which to plot protein numbers
(output from \code{\link{make_se}()} or \code{\link{make_se_parse}()}).}

\item{plot}{Logical(1),
If \code{TRUE} (default) the barplot is produced.
Otherwise (if \code{FALSE}), the data which the
barplot is based on are returned.}
}
\value{
Barplot of the number of identified proteins per sample
(generated by \code{\link[ggplot2]{ggplot}})
}
\description{
\code{plot_numbers} generates a barplot
of the number of identified proteins per sample.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter and plot numbers
filt <- filter_missval(se, thr = 0)
plot_numbers(filt)
}
