% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_QC.R
\name{plot_missval}
\alias{plot_missval}
\title{Plot a heatmap of proteins with missing values}
\usage{
plot_missval(se)
}
\arguments{
\item{se}{SummarizedExperiment,
Data object with missing values.}
}
\value{
A heatmap indicating whether values are missing (0) or not (1)
(generated by \code{\link[ComplexHeatmap]{Heatmap}}).
}
\description{
\code{plot_missval} generates a heatmap of proteins
with missing values to discover whether values are missing by random or not.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter, normalize and impute missing values
filt <- filter_missval(se, thr = 0)

# Plot missing values heatmap
plot_missval(filt)
}
