% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions_frequencies.R
\name{plot_frequency}
\alias{plot_frequency}
\title{Plot protein overlap between samples}
\usage{
plot_frequency(se, plot = TRUE)
}
\arguments{
\item{se}{SummarizedExperiment,
Data object for which to plot observation frequency.}

\item{plot}{Logical(1),
If \code{TRUE} (default) the barplot is produced.
Otherwise (if \code{FALSE}), the data which the
barplot is based on are returned.}
}
\value{
Barplot of overlap of protein identifications
between samples (generated by \code{\link[ggplot2]{ggplot}})
}
\description{
\code{plot_frequency} generates a barplot
of the protein overlap between samples
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter and plot frequency
filt <- filter_missval(se, thr = 0)
plot_frequency(filt)
}
