% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{normalize_vsn}
\alias{normalize_vsn}
\title{Normalization using vsn}
\usage{
normalize_vsn(se)
}
\arguments{
\item{se}{SummarizedExperiment,
Proteomics data (output from \code{\link{make_se}()} or
\code{\link{make_se_parse}()}). It is adviced to first remove
proteins with too many missing values using \code{\link{filter_missval}()}.}
}
\value{
A normalized SummarizedExperiment object.
}
\description{
\code{normalize_vsn} performs variance stabilizing transformation
using the \code{\link[vsn]{vsn-package}}.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter and normalize
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)
}
