% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{manual_impute}
\alias{manual_impute}
\title{Imputation by random draws from a manually defined distribution}
\usage{
manual_impute(se, scale = 0.3, shift = 1.8)
}
\arguments{
\item{se}{SummarizedExperiment,
Proteomics data (output from \code{\link{make_se}()} or
\code{\link{make_se_parse}()}). It is adviced to first remove
proteins with too many missing values using \code{\link{filter_missval}()}
and normalize the data using \code{\link{normalize_vsn}()}.}

\item{scale}{Numeric(1),
Sets the width of the distribution relative to the
standard deviation of the original distribution.}

\item{shift}{Numeric(1),
Sets the left-shift of the distribution (in standard deviations) from
the median of the original distribution.}
}
\value{
An imputed SummarizedExperiment object.
}
\description{
\code{manual_impute} imputes missing values in a proteomics dataset
by random draws from a manually defined distribution.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter and normalize
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)

# Impute missing values manually
imputed_manual <- impute(norm, fun = "man", shift = 1.8, scale = 0.3)
}
