% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{impute}
\alias{impute}
\title{Impute missing values}
\usage{
impute(
  se,
  fun = c("bpca", "knn", "QRILC", "MLE", "MinDet", "MinProb", "man", "min", "zero",
    "mixed", "nbavg"),
  ...
)
}
\arguments{
\item{se}{SummarizedExperiment,
Proteomics data (output from \code{\link{make_se}()} or
\code{\link{make_se_parse}()}). It is adviced to first remove
proteins with too many missing values using \code{\link{filter_missval}()}
and normalize the data using \code{\link{normalize_vsn}()}.}

\item{fun}{"bpca", "knn", "QRILC", "MLE", "MinDet",
"MinProb", "man", "min", "zero", "mixed" or "nbavg",
Function used for data imputation based on \code{\link{manual_impute}}
and \code{\link[MSnbase:impute]{impute}}.}

\item{...}{Additional arguments for imputation functions as depicted in
\code{\link{manual_impute}} and \code{\link[MSnbase:impute]{impute}}.}
}
\value{
An imputed SummarizedExperiment object.
}
\description{
\code{impute} imputes missing values in a proteomics dataset.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter and normalize
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)

# Impute missing values using different functions
imputed_MinProb <- impute(norm, fun = "MinProb", q = 0.05)
imputed_QRILC <- impute(norm, fun = "QRILC")

imputed_knn <- impute(norm, fun = "knn", k = 10, rowmax = 0.9)
imputed_MLE <- impute(norm, fun = "MLE")

imputed_manual <- impute(norm, fun = "man", shift = 1.8, scale = 0.3)
}
